//
//  YHGrabNumberListCell.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGrabingNumberListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHGrabingNumberListCell"
    var cancelAppointBlock: ((YHAppointMemberGroupModel)->())?
    
    let baseListTag = 9527
    var listArr: [YHAppointMemberGroupModel] = [] {
        didSet {
            listContainView.removeSubviews()
            var lastView: YHGrabingNumberListView? = nil
            for  (index, group) in listArr.enumerated() {
                let listView = YHGrabingNumberListView(frame: .zero)
                listView.tag = baseListTag + index
                let chineseNum = convertNumberToChineseText(index+1)
                listView.titleLabel.text = "第\(chineseNum)批"
                listView.membersLabel.text = "成员：\(group.getMemberNames())"
                listView.cancelBlock = {
                    [weak self] in
                    guard let self = self else { return }
                    self.cancelAppointBlock?(group)
                }
                
                // 抢号信息
                let items1 = [YHGrabItem(type: .grab, title: "赴港时间：", detail: "抢号中", isSingleLine: true),
                              YHGrabItem(type: .grab, title: "香港入境处：", detail: "抢号中", isSingleLine: true),
                              YHGrabItem(type: .grab, title: "抢号反馈回执：", detail: "抢号中",isSingleLine: true),]
                listView.grabInfoView.updateItems(items1)
                
                // 意向信息
                var wantTimeText = "\(group.wantMinTime) ~ \(group.wantMaxTime)"
                if group.wantMinTime == group.wantMaxTime {
                    wantTimeText = group.wantMinTime
                }
                let items2 = [YHGrabItem(type: .info, title: "期望赴港时间：", detail: wantTimeText,isSingleLine: true),
                              YHGrabItem(type: .info, title: "期望香港办证点：", detail: group.wantImmigrationOffice, isSingleLine: false)]

                listView.intentionInfoView.updateItems(items2)

                listContainView.addSubview(listView)
                listView.snp.makeConstraints { make in
                    make.left.equalTo(18)
                    make.right.equalTo(-18)
                    if let last = lastView {
                        make.top.equalTo(last.snp.bottom).offset(16)
                    } else {
                        make.top.equalTo(listContainView.snp.top)
                    }
                    
                    if index == listArr.count-1 {
                        make.bottom.equalTo(-16)
                    }
                }
                lastView = listView
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = .mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "赴港办理抢号中批次"
        return label
    }()
    
    lazy var listContainView: UIView = {
        let view = UIView()
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(listContainView)

        
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        listContainView.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(0)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    //阿拉伯数字转文字
    func convertNumberToChineseText(_ number: Int) -> String {
        let numberFormatter = NumberFormatter()
        numberFormatter.locale = Locale(identifier: "zh_CN")
        numberFormatter.numberStyle = .spellOut
        return numberFormatter.string(from: NSNumber(value: number)) ?? ""
    }
}
